*! version 5.0
* 13 August 2018
* NIDS
* Master Income do file for Nids Wave 3

* THIS IS 5th INCOME DO FILE - PRE-IMPUTATION AGGREGATION DO FILE: 5 OF 7
* This file creates production-level and income variables for section h (agriculture) of the household questionaire

*=====================================================================================================================================
* GLOBALS FOR DATA FILES, DO FILES AND VERSION SUFFIXES

* DEFINED IN "Master Income do file (1 of 7)"



*=====================================================================================================================================

use "$DataIN\HHQuestionnaire_$VersionIN.dta", clear

**Mielies**

gen mieliekg=.
replace mieliekg=w1_h_agcrmlhar/5 if  w1_h_agcrmlu==1
replace mieliekg=w1_h_agcrmlhar if  w1_h_agcrmlu==2
replace mieliekg=w1_h_agcrmlhar*10 if  w1_h_agcrmlu==3
replace mieliekg=w1_h_agcrmlhar*25 if  w1_h_agcrmlu==4
replace mieliekg=w1_h_agcrmlhar*50 if  w1_h_agcrmlu==5
replace mieliekg=w1_h_agcrmlhar*80 if  w1_h_agcrmlu==6
replace mieliekg=w1_h_agcrmlhar*1000 if  w1_h_agcrmlu==7
replace mieliekg=w1_h_agcrmlhar*20 if  w1_h_agcrmlu==10
replace mieliekg=w1_h_agcrmlhar*2 if  w1_h_agcrmlu==20
replace mieliekg=w1_h_agcrmlhar*2 if  w1_h_agcrmlu==14
gen mieliekgsold=.
replace mieliekgsold=w1_h_agcrmlsll/5 if  w1_h_agcrmlu==1
replace mieliekgsold=w1_h_agcrmlsll if  w1_h_agcrmlu==2
replace mieliekgsold=w1_h_agcrmlsll*10 if  w1_h_agcrmlu==3
replace mieliekgsold=w1_h_agcrmlsll*25 if  w1_h_agcrmlu==4
replace mieliekgsold=w1_h_agcrmlsll*50 if  w1_h_agcrmlu==5
replace mieliekgsold=w1_h_agcrmlsll*80 if  w1_h_agcrmlu==6
replace mieliekgsold=w1_h_agcrmlsll*1000 if  w1_h_agcrmlu==7
replace mieliekgsold=w1_h_agcrmlsll*20 if  w1_h_agcrmlu==10
replace mieliekgsold=w1_h_agcrmlsll*2 if  w1_h_agcrmlu==20
replace mieliekgsold=w1_h_agcrmlsll*2 if  w1_h_agcrmlu==14
gen mieliekgaway=.
replace mieliekgaway= w1_h_agcrmlgv/5 if  w1_h_agcrmlu==1
replace mieliekgaway= w1_h_agcrmlgv if  w1_h_agcrmlu==2
replace mieliekgaway= w1_h_agcrmlgv*10 if  w1_h_agcrmlu==3
replace mieliekgaway= w1_h_agcrmlgv*25 if  w1_h_agcrmlu==4
replace mieliekgaway= w1_h_agcrmlgv*50 if  w1_h_agcrmlu==5
replace mieliekgaway= w1_h_agcrmlgv*80 if  w1_h_agcrmlu==6
replace mieliekgaway= w1_h_agcrmlgv*1000 if  w1_h_agcrmlu==7
replace mieliekgaway= w1_h_agcrmlgv*20 if  w1_h_agcrmlu==10
replace mieliekgaway= w1_h_agcrmlgv*2 if  w1_h_agcrmlu==14
replace mieliekgaway= w1_h_agcrmlgv*2 if  w1_h_agcrmlu==20
gen mieliekgretained=.
replace mieliekgretained= w1_h_agcrmlcon/5 if  w1_h_agcrmlu==1
replace mieliekgretained= w1_h_agcrmlcon*2 if  w1_h_agcrmlu==14
replace mieliekgretained= w1_h_agcrmlcon*2 if  w1_h_agcrmlu==20

**Sorghum**

gen sorghumkg=.
replace sorghumkg=w1_h_agcrsorhar*25 if w1_h_agcrsoru==4
gen sorghumkgsold=.
replace sorghumkgsold=w1_h_agcrsorgv*25 if w1_h_agcrsoru==4
gen sorghumkgretained=.
replace sorghumkgretained=w1_h_agcrsorcon*25 if w1_h_agcrsoru==4

**Wheat**

gen wheatkg=.
replace wheatkg= w1_h_agcrwhthar*1000 if  w1_h_agcrwhtu==7
replace wheatkg= w1_h_agcrwhthar*1000 if  w1_h_agcrwhtu==9
**this is because both 7 and 9 were coded as "tons" here**
gen wheatkgsold=.
replace wheatkgsold= w1_h_agcrwhtsll*1000 if  w1_h_agcrwhtu==7
replace wheatkgsold= w1_h_agcrwhtsll*1000 if  w1_h_agcrwhtu==9

**Millet**

**there is only one HH that reported a positive figure for harvesting this crop in the last 12 months. It reported that it harvested 20 individual units of millet.
**Make the same assumptions about weight and value as mielies. The HH in question harvested millet but did not sell, give away or consume the produce.**

gen milletkg=.
replace milletkg= w1_h_agcrmilhar/5 if  w1_h_agcrmilu==1

**Lucerne and other pasture crops**

gen lucernekg=.
replace lucernekg= w1_h_agcrpashar*10 if  w1_h_agcrpasu==3
replace lucernekg= w1_h_agcrpashar*25 if  w1_h_agcrpasu==4
replace lucernekg= w1_h_agcrpashar*1000 if  w1_h_agcrpasu==7
gen lucernekgsold=.
replace lucernekgsold= w1_h_agcrpassll*25 if  w1_h_agcrpasu==4
replace lucernekgsold= w1_h_agcrpassll*1000 if  w1_h_agcrpasu==7
gen lucernekgretained=.
replace lucernekgretained= w1_h_agcrpascon*10 if  w1_h_agcrpasu==3
replace lucernekgretained= w1_h_agcrpascon*25 if  w1_h_agcrpasu==4
replace lucernekgretained= w1_h_agcrpascon*1000 if  w1_h_agcrpasu==7

**Cotton**

gen cottonkg=.
replace cottonkg= w1_h_agcrcothar*1000 if  w1_h_agcrcotu==7
gen cottonkgsold=.
replace cottonkgsold= w1_h_agcrcotsll*1000 if  w1_h_agcrcotu==7
gen cottonkgretained=.
replace cottonkgretained= w1_h_agcrcotcon*1000 if  w1_h_agcrcotu==7

**Sugar Cane**

gen sugarcanekg=.
replace sugarcanekg= w1_h_agcrsughar/2 if  w1_h_agcrsugu==1
replace sugarcanekg= w1_h_agcrsughar if  w1_h_agcrsugu==2
replace sugarcanekg= w1_h_agcrsughar*10 if  w1_h_agcrsugu==3
replace sugarcanekg= w1_h_agcrsughar*25 if  w1_h_agcrsugu==4
replace sugarcanekg= w1_h_agcrsughar*1000 if  w1_h_agcrsugu==7
replace sugarcanekg= w1_h_agcrsughar*20 if  w1_h_agcrsugu==10
gen sugarcanekgsold=.
replace sugarcanekgsold= w1_h_agcrsugsll/2 if  w1_h_agcrsugu==1
replace sugarcanekgsold= w1_h_agcrsugsll if  w1_h_agcrsugu==2
replace sugarcanekgsold= w1_h_agcrsugsll*25 if  w1_h_agcrsugu==4
replace sugarcanekgsold= w1_h_agcrsugsll*1000 if  w1_h_agcrsugu==7
replace sugarcanekgsold= w1_h_agcrsugsll*20 if  w1_h_agcrsugu==10
gen sugarcanekgaway=.
replace sugarcanekgaway= w1_h_agcrsuggv/2 if  w1_h_agcrsugu==1
replace sugarcanekgaway= w1_h_agcrsuggv if  w1_h_agcrsugu==2
replace sugarcanekgaway= w1_h_agcrsuggv*25 if  w1_h_agcrsugu==4
replace sugarcanekgaway= w1_h_agcrsuggv*1000 if  w1_h_agcrsugu==7
replace sugarcanekgaway= w1_h_agcrsuggv*20 if  w1_h_agcrsugu==10
gen sugarcanekgretained=.
replace sugarcanekgretained= w1_h_agcrsugcon/2 if  w1_h_agcrsugu==1
replace sugarcanekgretained= w1_h_agcrsugcon if  w1_h_agcrsugu==2
replace sugarcanekgretained= w1_h_agcrsugcon*25 if  w1_h_agcrsugu==4
replace sugarcanekgretained= w1_h_agcrsugcon*1000 if  w1_h_agcrsugu==7
replace sugarcanekgretained= w1_h_agcrsugcon*20 if  w1_h_agcrsugu==10

**Tea**
**Only 1 HH reported a positive harvest of tea in the last year. This was 40 individual units of tea. Assume that a unit of tea means a bunch and that this weighs 500g**

gen teakg=.
replace teakg= w1_h_agcrteahar/2 if  w1_h_agcrteau==1
**None of this tea was sold**
gen teakgaway=.
replace teakgaway= w1_h_agcrteagv/2 if  w1_h_agcrteau==1
gen teakgretained=.
replace teakgretained=w1_h_agcrteacon/2 if w1_h_agcrteau==1

**Other grains**

gen othergrainkg=.
replace othergrainkg= w1_h_agcrgrnhar*25 if  w1_h_agcrgrnu==4
gen othergrainkgsold=.
replace othergrainkgsold= w1_h_agcrgrnsll*25 if  w1_h_agcrgrnu==4

**Deciduous fruit**

gen deciduouskg=.
replace deciduouskg= w1_h_agcrdechar/6.67 if  w1_h_agcrdecu==1
replace deciduouskg= w1_h_agcrdechar if  w1_h_agcrdecu==2
replace deciduouskg= w1_h_agcrdechar*10 if  w1_h_agcrdecu==3
replace deciduouskg= w1_h_agcrdechar*80 if  w1_h_agcrdecu==6
replace deciduouskg= w1_h_agcrdechar*1000 if  w1_h_agcrdecu==7
replace deciduouskg= w1_h_agcrdechar*15 if  w1_h_agcrdecu==8
replace deciduouskg= w1_h_agcrdechar*1000 if  w1_h_agcrdecu==9
replace  w1_h_agcrdecu=7 if  w1_h_agcrdecu==9
**the last command is to account for the one example in which tons is coded as 9 instead of 7**
gen deciduouskgsold=.
replace deciduouskgsold= w1_h_agcrdecsll/6.67 if  w1_h_agcrdecu==1
replace deciduouskgsold= w1_h_agcrdecsll if  w1_h_agcrdecu==2
replace deciduouskgsold= w1_h_agcrdecsll*10 if  w1_h_agcrdecu==3
replace deciduouskgsold= w1_h_agcrdecsll*80 if  w1_h_agcrdecu==6
replace deciduouskgsold= w1_h_agcrdecsll*1000 if  w1_h_agcrdecu==7
replace deciduouskgsold= w1_h_agcrdecsll*15 if  w1_h_agcrdecu==8
gen deciduouskgaway=.
replace deciduouskgaway= w1_h_agcrdecgv/6.67 if  w1_h_agcrdecu==1
replace deciduouskgaway= w1_h_agcrdecgv if  w1_h_agcrdecu==2
replace deciduouskgaway= w1_h_agcrdecgv*10 if  w1_h_agcrdecu==3
replace deciduouskgaway= w1_h_agcrdecgv*80 if  w1_h_agcrdecu==6
replace deciduouskgaway= w1_h_agcrdecgv*1000 if  w1_h_agcrdecu==7
replace deciduouskgaway= w1_h_agcrdecgv*15 if  w1_h_agcrdecu==8
gen deciduouskgretained=.
replace deciduouskgretained= w1_h_agcrdeccon/6.67 if  w1_h_agcrdecu==1
replace deciduouskgretained= w1_h_agcrdeccon if  w1_h_agcrdecu==2
replace deciduouskgretained= w1_h_agcrdeccon*10 if  w1_h_agcrdecu==3
replace deciduouskgretained= w1_h_agcrdeccon*80 if  w1_h_agcrdecu==6
replace deciduouskgretained= w1_h_agcrdeccon*1000 if  w1_h_agcrdecu==7
replace deciduouskgretained= w1_h_agcrdeccon*15 if  w1_h_agcrdecu==8

**Citrus fruit**

gen citruskg=.
replace citruskg= w1_h_agcrcithar/6.67 if  w1_h_agcrcitu==1
replace citruskg= w1_h_agcrcithar if  w1_h_agcrcitu==2
replace citruskg= w1_h_agcrcithar*10 if  w1_h_agcrcitu==3
replace citruskg= w1_h_agcrcithar*50 if  w1_h_agcrcitu==5
replace citruskg= w1_h_agcrcithar*15 if  w1_h_agcrcitu==8
gen citruskgsold=.
replace citruskgsold= w1_h_agcrcitsll/6.67 if  w1_h_agcrcitu==1
replace citruskgsold= w1_h_agcrcitsll if  w1_h_agcrcitu==2
replace citruskgsold= w1_h_agcrcitsll*10 if  w1_h_agcrcitu==3
replace citruskgsold= w1_h_agcrcitsll*50 if  w1_h_agcrcitu==5
replace citruskgsold= w1_h_agcrcitsll*15 if  w1_h_agcrcitu==8
gen citruskgaway=.
replace citruskgaway= w1_h_agcrcitgv/6.67 if  w1_h_agcrcitu==1
replace citruskgaway= w1_h_agcrcitgv if  w1_h_agcrcitu==2
replace citruskgaway= w1_h_agcrcitgv*10 if  w1_h_agcrcitu==3
replace citruskgaway= w1_h_agcrcitgv*50 if  w1_h_agcrcitu==5
replace citruskgaway= w1_h_agcrcitgv*15 if  w1_h_agcrcitu==8
gen citruskgretained=.
replace citruskgretained= w1_h_agcrcitcon/6.67 if  w1_h_agcrcitu==1
replace citruskgretained= w1_h_agcrcitcon if  w1_h_agcrcitu==2
replace citruskgretained= w1_h_agcrcitcon*10 if  w1_h_agcrcitu==3
replace citruskgretained= w1_h_agcrcitcon*15 if  w1_h_agcrcitu==8

**Subtropical fruit**

gen subtropkg=.
replace subtropkg= w1_h_agcrsubhar/6.67 if  w1_h_agcrsubu==1
replace subtropkg= w1_h_agcrsubhar if  w1_h_agcrsubu==2
replace subtropkg= w1_h_agcrsubhar*10 if  w1_h_agcrsubu==3
replace subtropkg= w1_h_agcrsubhar*25 if  w1_h_agcrsubu==4
replace subtropkg= w1_h_agcrsubhar*5 if  w1_h_agcrsubu==13
**assume again that a crate weighs 15kg**
replace subtropkg= w1_h_agcrsubhar*15 if  w1_h_agcrsubu==8
replace  w1_h_agcrsubu=. if  w1_h_agcrsubu==11
gen subtropkgsold=.
replace subtropkgsold= w1_h_agcrsubsll/6.67 if  w1_h_agcrsubu==1
replace subtropkgsold= w1_h_agcrsubsll if  w1_h_agcrsubu==2
replace subtropkgsold= w1_h_agcrsubsll*10 if  w1_h_agcrsubu==3
replace subtropkgsold= w1_h_agcrsubsll*25 if  w1_h_agcrsubu==4
replace subtropkgsold= w1_h_agcrsubsll*15 if  w1_h_agcrsubu==8
replace subtropkgsold= w1_h_agcrsubsll*5 if  w1_h_agcrsubu==13
gen subtropkgaway=.
replace subtropkgaway= w1_h_agcrsubgv/6.67 if  w1_h_agcrsubu==1
replace subtropkgaway= w1_h_agcrsubgv if  w1_h_agcrsubu==2
replace subtropkgaway= w1_h_agcrsubgv*10 if  w1_h_agcrsubu==3
replace subtropkgaway= w1_h_agcrsubgv*25 if  w1_h_agcrsubu==4
replace subtropkgaway= w1_h_agcrsubgv*15 if  w1_h_agcrsubu==8
replace subtropkgaway= w1_h_agcrsubgv*5 if  w1_h_agcrsubu==13
gen subtropkgretained=.
replace subtropkgretained= w1_h_agcrsubcon/6.67 if  w1_h_agcrsubu==1
replace subtropkgretained= w1_h_agcrsubcon if  w1_h_agcrsubu==2
replace subtropkgretained= w1_h_agcrsubcon*10 if  w1_h_agcrsubu==3
replace subtropkgretained= w1_h_agcrsubcon*25 if  w1_h_agcrsubu==4
replace subtropkgretained= w1_h_agcrsubcon*15 if  w1_h_agcrsubu==8
replace subtropkgretained= w1_h_agcrsubcon*5 if  w1_h_agcrsubu==13

**Other fruit**

gen otherfrkg=.
replace otherfrkg= w1_h_agcrfohar/20 if  w1_h_agcrfou==1
replace otherfrkg= w1_h_agcrfohar if  w1_h_agcrfou==2
replace otherfrkg= w1_h_agcrfohar*10 if  w1_h_agcrfou==3
gen otherfrkgaway=.
replace otherfrkgaway= w1_h_agcrfogv if  w1_h_agcrfou==2
gen otherfrkgretained=.
replace otherfrkgretained= w1_h_agcrfocon if  w1_h_agcrfou==2

**Tomato**

gen tomatokg=.
replace tomatokg= w1_h_agcrtomhar/10 if  w1_h_agcrtomu==1
replace tomatokg= w1_h_agcrtomhar if  w1_h_agcrtomu==2
replace tomatokg= w1_h_agcrtomhar*10 if  w1_h_agcrtomu==3
replace tomatokg= w1_h_agcrtomhar*25 if  w1_h_agcrtomu==4
replace tomatokg= w1_h_agcrtomhar*80 if  w1_h_agcrtomu==6
replace tomatokg= w1_h_agcrtomhar/2 if  w1_h_agcrtomu==13
**assume that a crate holds 15kgs**
replace tomatokg= w1_h_agcrtomhar*15 if  w1_h_agcrtomu==8
replace tomatokg= w1_h_agcrtomhar*20 if  w1_h_agcrtomu==10
replace  w1_h_agcrtomsll=-9 if  w1_h_agcrtomu==11|w1_h_agcrtomu==99
gen tomatokgsold=.
replace tomatokgsold= w1_h_agcrtomsll/10 if  w1_h_agcrtomu==1
replace tomatokgsold= w1_h_agcrtomsll if  w1_h_agcrtomu==2
replace tomatokgsold= w1_h_agcrtomsll*10 if  w1_h_agcrtomu==3
replace tomatokgsold= w1_h_agcrtomsll*25 if  w1_h_agcrtomu==4
replace tomatokgsold= w1_h_agcrtomsll*80 if  w1_h_agcrtomu==6
replace tomatokgsold= w1_h_agcrtomsll*15 if  w1_h_agcrtomu==8
replace tomatokgsold= w1_h_agcrtomsll*20 if  w1_h_agcrtomu==10
replace tomatokgsold= w1_h_agcrtomsll/2 if  w1_h_agcrtomu==13
gen tomatokgaway=.
replace tomatokgaway= w1_h_agcrtomgv/10 if  w1_h_agcrtomu==1
replace tomatokgaway= w1_h_agcrtomgv if  w1_h_agcrtomu==2
replace tomatokgaway= w1_h_agcrtomgv*10 if  w1_h_agcrtomu==3
replace tomatokgaway= w1_h_agcrtomgv*25 if  w1_h_agcrtomu==4
replace tomatokgaway= w1_h_agcrtomgv*80 if  w1_h_agcrtomu==6
replace tomatokgaway= w1_h_agcrtomgv*15 if  w1_h_agcrtomu==8
replace tomatokgaway= w1_h_agcrtomgv*20 if  w1_h_agcrtomu==10
replace tomatokgaway= w1_h_agcrtomgv/2 if  w1_h_agcrtomu==13
gen tomatokgretained=.
replace tomatokgretained= w1_h_agcrtomcon/10 if  w1_h_agcrtomu==1
replace tomatokgretained= w1_h_agcrtomcon if  w1_h_agcrtomu==2
replace tomatokgretained= w1_h_agcrtomcon*10 if  w1_h_agcrtomu==3
replace tomatokgretained= w1_h_agcrtomcon*25 if  w1_h_agcrtomu==4
replace tomatokgretained= w1_h_agcrtomcon*80 if  w1_h_agcrtomu==6
replace tomatokgretained= w1_h_agcrtomcon*15 if  w1_h_agcrtomu==8
replace tomatokgretained= w1_h_agcrtomcon*20 if  w1_h_agcrtomu==10
replace tomatokgretained= w1_h_agcrtomcon/2 if  w1_h_agcrtomu==13

**Spinach**

gen spinachkg=.
replace spinachkg= w1_h_agcrspihar/5 if  w1_h_agcrspiu==1
replace spinachkg= w1_h_agcrspihar if  w1_h_agcrspiu==2
replace spinachkg= w1_h_agcrspihar*10 if  w1_h_agcrspiu==3
replace spinachkg= w1_h_agcrspihar*25 if  w1_h_agcrspiu==4
replace spinachkg= w1_h_agcrspihar*50 if  w1_h_agcrspiu==5
replace spinachkg= w1_h_agcrspihar/5 if  w1_h_agcrspiu==13
replace spinachkg= w1_h_agcrspihar*10 if  w1_h_agcrspiu==8
gen spinachkgsold=.
replace spinachkgsold= w1_h_agcrspisll/5 if  w1_h_agcrspiu==1
replace spinachkgsold= w1_h_agcrspisll if  w1_h_agcrspiu==2
replace spinachkgsold= w1_h_agcrspisll*10 if  w1_h_agcrspiu==3
replace spinachkgsold= w1_h_agcrspisll*25 if  w1_h_agcrspiu==4
replace spinachkgsold= w1_h_agcrspisll*50 if  w1_h_agcrspiu==5
replace spinachkgsold= w1_h_agcrspisll*10 if  w1_h_agcrspiu==8
replace spinachkgsold= w1_h_agcrspisll*1000 if  w1_h_agcrspiu==9
replace spinachkgsold= w1_h_agcrspisll/5 if  w1_h_agcrspiu==13
gen spinachkgaway=.
replace spinachkgaway= w1_h_agcrspigv/5 if  w1_h_agcrspiu==1
replace spinachkgaway= w1_h_agcrspigv if  w1_h_agcrspiu==2
replace spinachkgaway= w1_h_agcrspigv*10 if  w1_h_agcrspiu==3
replace spinachkgaway= w1_h_agcrspigv*25 if  w1_h_agcrspiu==4
replace spinachkgaway= w1_h_agcrspigv*50 if  w1_h_agcrspiu==5
replace spinachkgaway= w1_h_agcrspigv*10 if  w1_h_agcrspiu==8
replace spinachkgaway= w1_h_agcrspigv*1000 if  w1_h_agcrspiu==9
replace spinachkgaway= w1_h_agcrspigv/5 if  w1_h_agcrspiu==13
gen spinachkgretained=.
replace spinachkgretained= w1_h_agcrspicon/5 if  w1_h_agcrspiu==1
replace spinachkgretained= w1_h_agcrspicon if  w1_h_agcrspiu==2
replace spinachkgretained= w1_h_agcrspicon*10 if  w1_h_agcrspiu==3
replace spinachkgretained= w1_h_agcrspicon*25 if  w1_h_agcrspiu==4
replace spinachkgretained= w1_h_agcrspicon*50 if  w1_h_agcrspiu==5
replace spinachkgretained= w1_h_agcrspicon*10 if  w1_h_agcrspiu==8
replace spinachkgretained= w1_h_agcrspicon/5 if  w1_h_agcrspiu==13

**Morogo**

gen marogokg=.
replace marogokg= w1_h_agcrwshar/5 if w1_h_agcrwsu==1
replace marogokg= w1_h_agcrwshar if w1_h_agcrwsu==2
replace marogokg= w1_h_agcrwshar*10 if w1_h_agcrwsu==3
replace marogokg= w1_h_agcrwshar*25 if w1_h_agcrwsu==4
replace marogokg= w1_h_agcrwshar*1000 if w1_h_agcrwsu==7
replace marogokg= w1_h_agcrwshar*1000 if w1_h_agcrwsu==9
replace marogokg= w1_h_agcrwshar*20 if w1_h_agcrwsu==10
replace marogokg= w1_h_agcrwshar/5 if w1_h_agcrwsu==13
gen marogokgsold=.
replace marogokgsold= w1_h_agcrwssll/5 if w1_h_agcrwsu==1
replace marogokgsold= w1_h_agcrwssll if w1_h_agcrwsu==2
replace marogokgsold= w1_h_agcrwssll*10 if w1_h_agcrwsu==3
replace marogokgsold= w1_h_agcrwssll*25 if w1_h_agcrwsu==4
replace marogokgsold= w1_h_agcrwssll*1000 if w1_h_agcrwsu==9
replace marogokgsold= w1_h_agcrwssll*20 if w1_h_agcrwsu==10
replace marogokgsold= w1_h_agcrwssll/5 if w1_h_agcrwsu==13
gen marogokgaway=.
replace marogokgaway= w1_h_agcrwsgv/5 if w1_h_agcrwsu==1
replace marogokgaway= w1_h_agcrwsgv if w1_h_agcrwsu==2
replace marogokgaway= w1_h_agcrwsgv*10 if w1_h_agcrwsu==3
replace marogokgaway= w1_h_agcrwsgv*25 if w1_h_agcrwsu==4
replace marogokgaway= w1_h_agcrwsgv*1000 if w1_h_agcrwsu==9
replace marogokgaway= w1_h_agcrwsgv*20 if w1_h_agcrwsu==10
replace marogokgaway= w1_h_agcrwsgv/5 if w1_h_agcrwsu==13
gen marogokgretained=.
replace marogokgretained= w1_h_agcrwscon/5 if w1_h_agcrwsu==1
replace marogokgretained= w1_h_agcrwscon if w1_h_agcrwsu==2
replace marogokgretained= w1_h_agcrwscon*10 if w1_h_agcrwsu==3
replace marogokgretained= w1_h_agcrwscon*25 if w1_h_agcrwsu==4
replace marogokgretained= w1_h_agcrwscon*20 if w1_h_agcrwsu==10
replace marogokgretained= w1_h_agcrwscon/5 if w1_h_agcrwsu==13

**Cabbage**

gen cabbagekg=.
replace cabbagekg= w1_h_agcrcabhar/2 if  w1_h_agcrcabu==1
replace cabbagekg= w1_h_agcrcabhar if  w1_h_agcrcabu==2
replace cabbagekg= w1_h_agcrcabhar*10 if  w1_h_agcrcabu==3
replace cabbagekg= w1_h_agcrcabhar*5 if  w1_h_agcrcabu==8
gen cabbagekgsold=.
replace cabbagekgsold= w1_h_agcrcabsll/2 if  w1_h_agcrcabu==1
replace cabbagekgsold= w1_h_agcrcabsll if  w1_h_agcrcabu==2
replace cabbagekgsold= w1_h_agcrcabsll*10 if  w1_h_agcrcabu==3
replace cabbagekgsold=. if cabbagekgsold>70
gen cabbagekgaway=.
replace cabbagekgaway= w1_h_agcrcabgv/2 if  w1_h_agcrcabu==1
replace cabbagekgaway= w1_h_agcrcabgv if  w1_h_agcrcabu==2
replace cabbagekgaway= w1_h_agcrcabgv*10 if  w1_h_agcrcabu==3
gen cabbagekgretained=.
replace cabbagekgretained= w1_h_agcrcabcon/2 if  w1_h_agcrcabu==1
replace cabbagekgretained= w1_h_agcrcabcon if  w1_h_agcrcabu==2
replace cabbagekgretained= w1_h_agcrcabcon*10 if  w1_h_agcrcabu==3

**Potato**

gen potatokg=.
replace potatokg= w1_h_agcrpothar/5 if  w1_h_agcrpotu==1
replace potatokg= w1_h_agcrpothar if  w1_h_agcrpotu==2
replace potatokg= w1_h_agcrpothar*10 if  w1_h_agcrpotu==3
replace potatokg= w1_h_agcrpothar*25 if  w1_h_agcrpotu==4
replace potatokg= w1_h_agcrpothar*50 if  w1_h_agcrpotu==5
replace potatokg= w1_h_agcrpothar*15 if  w1_h_agcrpotu==8
replace potatokg= w1_h_agcrpothar*20 if  w1_h_agcrpotu==10
replace potatokg= w1_h_agcrpothar*4 if  w1_h_agcrpotu==20
gen potatokgsold=.
replace potatokgsold= w1_h_agcrpotsll/5 if  w1_h_agcrpotu==1
replace potatokgsold= w1_h_agcrpotsll if  w1_h_agcrpotu==2
replace potatokgsold= w1_h_agcrpotsll*10 if  w1_h_agcrpotu==3
replace potatokgsold= w1_h_agcrpotsll*25 if  w1_h_agcrpotu==4
replace potatokgsold= w1_h_agcrpotsll*15 if  w1_h_agcrpotu==8
replace potatokgsold= w1_h_agcrpotsll*20 if  w1_h_agcrpotu==10
replace potatokgsold= w1_h_agcrpotsll*4 if  w1_h_agcrpotu==20
replace  w1_h_agcrpotgv=-9 if  w1_h_agcrpotu==99
gen potatokgaway=.
replace potatokgaway= w1_h_agcrpotgv/5 if  w1_h_agcrpotu==1
replace potatokgaway= w1_h_agcrpotgv if  w1_h_agcrpotu==2
replace potatokgaway= w1_h_agcrpotgv*10 if  w1_h_agcrpotu==3
replace potatokgaway= w1_h_agcrpotgv*25 if  w1_h_agcrpotu==4
replace potatokgaway= w1_h_agcrpotgv*15 if  w1_h_agcrpotu==8
replace potatokgaway= w1_h_agcrpotgv*20 if  w1_h_agcrpotu==10
replace potatokgaway= w1_h_agcrpotgv*4 if  w1_h_agcrpotu==20
gen potatokgretained=.
replace potatokgretained= w1_h_agcrpotcon/5 if  w1_h_agcrpotu==1
replace potatokgretained= w1_h_agcrpotcon if  w1_h_agcrpotu==2
replace potatokgretained= w1_h_agcrpotcon*10 if  w1_h_agcrpotu==3
replace potatokgretained= w1_h_agcrpotcon*25 if  w1_h_agcrpotu==4
replace potatokgretained= w1_h_agcrpotcon*15 if  w1_h_agcrpotu==8
replace potatokgretained= w1_h_agcrpotcon*20 if  w1_h_agcrpotu==10
replace potatokgretained= w1_h_agcrpotcon*4 if  w1_h_agcrpotu==20

**Pumpkin**

gen pumpkinkg=.
replace pumpkinkg= w1_h_agcrpmphar*1.5 if  w1_h_agcrpmpu==1
replace pumpkinkg= w1_h_agcrpmphar if  w1_h_agcrpmpu==2
replace pumpkinkg= w1_h_agcrpmphar*10 if  w1_h_agcrpmpu==3
replace pumpkinkg= w1_h_agcrpmphar*25 if  w1_h_agcrpmpu==4
replace pumpkinkg= w1_h_agcrpmphar*80 if  w1_h_agcrpmpu==6
replace pumpkinkg= w1_h_agcrpmphar*10 if  w1_h_agcrpmpu==8
gen pumpkinkgsold=.
replace pumpkinkgsold= w1_h_agcrpmpsll*1.5 if  w1_h_agcrpmpu==1
replace pumpkinkgsold= w1_h_agcrpmpsll if  w1_h_agcrpmpu==2
replace pumpkinkgsold= w1_h_agcrpmpsll*10 if  w1_h_agcrpmpu==3
replace pumpkinkgsold= w1_h_agcrpmpsll*25 if  w1_h_agcrpmpu==4
replace pumpkinkgsold= w1_h_agcrpmpsll*80 if  w1_h_agcrpmpu==6
replace pumpkinkgsold= w1_h_agcrpmpsll*10 if  w1_h_agcrpmpu==8
gen pumpkinkgaway=.
replace pumpkinkgaway= w1_h_agcrpmpgv*1.5 if  w1_h_agcrpmpu==1
replace pumpkinkgaway= w1_h_agcrpmpgv if  w1_h_agcrpmpu==2
replace pumpkinkgaway= w1_h_agcrpmpgv*10 if  w1_h_agcrpmpu==3
replace pumpkinkgaway= w1_h_agcrpmpgv*25 if  w1_h_agcrpmpu==4
replace pumpkinkgaway= w1_h_agcrpmpgv*80 if  w1_h_agcrpmpu==6
replace pumpkinkgaway= w1_h_agcrpmpgv*10 if  w1_h_agcrpmpu==8
gen pumpkinkgretained=.
replace pumpkinkgretained= w1_h_agcrpmpcon*1.5 if  w1_h_agcrpmpu==1
replace pumpkinkgretained= w1_h_agcrpmpcon if  w1_h_agcrpmpu==2
replace pumpkinkgretained= w1_h_agcrpmpcon*10 if  w1_h_agcrpmpu==3
replace pumpkinkgretained= w1_h_agcrpmpcon*25 if  w1_h_agcrpmpu==4
replace pumpkinkgretained= w1_h_agcrpmpcon*80 if  w1_h_agcrpmpu==6
replace pumpkinkgretained= w1_h_agcrpmpcon*10 if  w1_h_agcrpmpu==8

**Carrots**

replace  w1_h_agcrcaru=2 if  w1_h_agcrcaru==12
gen carrotkg=.
replace carrotkg= w1_h_agcrcarhar/10 if  w1_h_agcrcaru==1
replace carrotkg= w1_h_agcrcarhar if  w1_h_agcrcaru==2
replace carrotkg= w1_h_agcrcarhar*10 if  w1_h_agcrcaru==3
replace carrotkg= w1_h_agcrcarhar*25 if  w1_h_agcrcaru==4
replace carrotkg= w1_h_agcrcarhar if  w1_h_agcrcaru==13
replace carrotkg= w1_h_agcrcarhar*3 if  w1_h_agcrcaru==20
gen carrotkgsold=.
replace carrotkgsold= w1_h_agcrcarsll/10 if  w1_h_agcrcaru==1
replace carrotkgsold= w1_h_agcrcarsll if  w1_h_agcrcaru==2
replace carrotkgsold= w1_h_agcrcarsll*10 if  w1_h_agcrcaru==3
replace carrotkgsold= w1_h_agcrcarsll*25 if  w1_h_agcrcaru==4
replace carrotkgsold= w1_h_agcrcarsll if  w1_h_agcrcaru==13
replace carrotkgsold= w1_h_agcrcarsll*3 if  w1_h_agcrcaru==20
gen carrotkgaway=.
replace carrotkgaway= w1_h_agcrcargv/10 if  w1_h_agcrcaru==1
replace carrotkgaway= w1_h_agcrcargv if  w1_h_agcrcaru==2
replace carrotkgaway= w1_h_agcrcargv*10 if  w1_h_agcrcaru==3
replace carrotkgaway= w1_h_agcrcargv*25 if  w1_h_agcrcaru==4
replace carrotkgaway= w1_h_agcrcargv if  w1_h_agcrcaru==13
replace carrotkgaway= w1_h_agcrcargv*3 if  w1_h_agcrcaru==20
gen carrotkgretained=.
replace carrotkgretained= w1_h_agcrcarcon/10 if  w1_h_agcrcaru==1
replace carrotkgretained= w1_h_agcrcarcon if  w1_h_agcrcaru==2
replace carrotkgretained= w1_h_agcrcarcon*10 if  w1_h_agcrcaru==3
replace carrotkgretained= w1_h_agcrcarcon*25 if  w1_h_agcrcaru==4
replace carrotkgretained= w1_h_agcrcarcon if  w1_h_agcrcaru==13
replace carrotkgretained= w1_h_agcrcarcon*3 if  w1_h_agcrcaru==20

**Madumbe**

gen madumbekg=.
replace madumbekg=w1_h_agcrmadhar/12.5 if  w1_h_agcrmadu==1
replace madumbekg=w1_h_agcrmadhar if  w1_h_agcrmadu==2
replace madumbekg=w1_h_agcrmadhar*10 if  w1_h_agcrmadu==3
replace madumbekg=w1_h_agcrmadhar*25 if  w1_h_agcrmadu==4
replace madumbekg=w1_h_agcrmadhar*50 if  w1_h_agcrmadu==5
replace madumbekg=w1_h_agcrmadhar*15 if  w1_h_agcrmadu==8
gen madumbekgsold=.
replace madumbekgsold= w1_h_agcrmadsll/12.5 if  w1_h_agcrmadu==1
replace madumbekgsold= w1_h_agcrmadsll if  w1_h_agcrmadu==2
replace madumbekgsold= w1_h_agcrmadsll*10 if  w1_h_agcrmadu==3
replace madumbekgsold= w1_h_agcrmadsll*25 if  w1_h_agcrmadu==4
replace madumbekgsold= w1_h_agcrmadsll*50 if  w1_h_agcrmadu==5
replace  w1_h_agcrmadgv=. if  w1_h_agcrmadu==99
gen madumbekgaway=.
replace madumbekgaway= w1_h_agcrmadgv/12.5 if  w1_h_agcrmadu==1
replace madumbekgaway= w1_h_agcrmadgv if  w1_h_agcrmadu==2
replace madumbekgaway= w1_h_agcrmadgv*10 if  w1_h_agcrmadu==3
replace madumbekgaway= w1_h_agcrmadgv*25 if  w1_h_agcrmadu==4
replace madumbekgaway= w1_h_agcrmadgv*50 if  w1_h_agcrmadu==5
replace madumbekgaway= w1_h_agcrmadgv*15 if  w1_h_agcrmadu==8
gen madumbekgretained=.
replace madumbekgretained= w1_h_agcrmadcon/12.5 if  w1_h_agcrmadu==1
replace madumbekgretained= w1_h_agcrmadcon if  w1_h_agcrmadu==2
replace madumbekgretained= w1_h_agcrmadcon*10 if  w1_h_agcrmadu==3
replace madumbekgretained= w1_h_agcrmadcon*25 if  w1_h_agcrmadu==4
replace madumbekgretained= w1_h_agcrmadcon*15 if  w1_h_agcrmadu==8

**Onions**

gen onionkg=.
replace onionkg= w1_h_agcronihar/10 if  w1_h_agcroniu==1
replace onionkg= w1_h_agcronihar if  w1_h_agcroniu==2
replace onionkg= w1_h_agcronihar*10 if  w1_h_agcroniu==3
replace onionkg= w1_h_agcronihar*25 if  w1_h_agcroniu==4
replace onionkg= w1_h_agcronihar*15 if  w1_h_agcroniu==8
gen onionkgsold=.
replace onionkgsold=w1_h_agcronisll/10 if  w1_h_agcroniu==1
replace onionkgsold=w1_h_agcronisll if  w1_h_agcroniu==2
replace onionkgsold=w1_h_agcronisll*10 if  w1_h_agcroniu==3
replace onionkgsold=w1_h_agcronisll*25 if  w1_h_agcroniu==4
replace onionkgsold=w1_h_agcronisll*15 if  w1_h_agcroniu==8
gen onionkgaway=.
replace onionkgaway=w1_h_agcronigv/10 if  w1_h_agcroniu==1
replace onionkgaway=w1_h_agcronigv if  w1_h_agcroniu==2
replace onionkgaway=w1_h_agcronigv*10 if  w1_h_agcroniu==3
replace onionkgaway=w1_h_agcronigv*25 if  w1_h_agcroniu==4
replace onionkgaway=w1_h_agcronigv*15 if  w1_h_agcroniu==8
gen onionkgretained=.
replace onionkgretained=w1_h_agcronicon/10 if  w1_h_agcroniu==1
replace onionkgretained=w1_h_agcronicon if  w1_h_agcroniu==2
replace onionkgretained=w1_h_agcronicon*10 if  w1_h_agcroniu==3
replace onionkgretained=w1_h_agcronicon*25 if  w1_h_agcroniu==4
replace onionkgretained=w1_h_agcronicon*15 if  w1_h_agcroniu==8

**Green beans**

gen gbeanskg=.
replace gbeanskg= w1_h_agcrgbhar/2 if w1_h_agcrgbu==1
replace gbeanskg= w1_h_agcrgbhar if w1_h_agcrgbu==2
replace gbeanskg= w1_h_agcrgbhar*10 if w1_h_agcrgbu==3
replace gbeanskg= w1_h_agcrgbhar*25 if w1_h_agcrgbu==4
replace gbeanskg= w1_h_agcrgbhar*50 if w1_h_agcrgbu==5
replace w1_h_agcrgbsll=. if w1_h_agcrgbu==99
gen gbeanskgsold=.
replace gbeanskgsold=w1_h_agcrgbsll/2 if w1_h_agcrgbu==1
replace gbeanskgsold=w1_h_agcrgbsll if w1_h_agcrgbu==2
replace gbeanskgsold=w1_h_agcrgbsll*10 if w1_h_agcrgbu==3
replace gbeanskgsold=w1_h_agcrgbsll*25 if w1_h_agcrgbu==4
replace gbeanskgsold=w1_h_agcrgbsll*50 if w1_h_agcrgbu==5
replace w1_h_agcrgbsll=. if w1_h_agcrgbu==9
gen gbeanskgaway=.
replace gbeanskgaway=w1_h_agcrgbgv/2 if w1_h_agcrgbu==1
replace gbeanskgaway=w1_h_agcrgbgv if w1_h_agcrgbu==2
replace gbeanskgaway=w1_h_agcrgbgv*10 if w1_h_agcrgbu==3
replace gbeanskgaway=w1_h_agcrgbgv*25 if w1_h_agcrgbu==4
replace gbeanskgaway=w1_h_agcrgbgv*50 if w1_h_agcrgbu==5
gen gbeanskgretained=.
replace gbeanskgretained=w1_h_agcrgbcon/2 if w1_h_agcrgbu==1
replace gbeanskgretained=w1_h_agcrgbcon if w1_h_agcrgbu==2
replace gbeanskgretained=w1_h_agcrgbcon*10 if w1_h_agcrgbu==3
replace gbeanskgretained=w1_h_agcrgbcon*25 if w1_h_agcrgbu==4
replace gbeanskgretained=w1_h_agcrgbcon*50 if w1_h_agcrgbu==5

**Dry beans**

gen dbeanskg=.
replace dbeanskg=w1_h_agcrdbhar/2 if w1_h_agcrdbu==1
replace dbeanskg=w1_h_agcrdbhar if w1_h_agcrdbu==2
replace dbeanskg=w1_h_agcrdbhar*10 if w1_h_agcrdbu==3
replace dbeanskg=w1_h_agcrdbhar*25 if w1_h_agcrdbu==4
replace dbeanskg=w1_h_agcrdbhar*50 if w1_h_agcrdbu==5
replace dbeanskg=w1_h_agcrdbhar*15 if w1_h_agcrdbu==8
replace dbeanskg=w1_h_agcrdbhar*20 if w1_h_agcrdbu==10
replace dbeanskg=w1_h_agcrdbhar/2 if w1_h_agcrdbu==13
replace w1_h_agcrdbgv=. if w1_h_agcrdbu==99
gen dbeanskgaway=.
replace dbeanskgaway=w1_h_agcrdbgv/2 if w1_h_agcrdbu==1
replace dbeanskgaway=w1_h_agcrdbgv if w1_h_agcrdbu==2
replace dbeanskgaway=w1_h_agcrdbgv*10 if w1_h_agcrdbu==3
replace dbeanskgaway=w1_h_agcrdbgv*25 if w1_h_agcrdbu==4
replace dbeanskgaway=w1_h_agcrdbgv*50 if w1_h_agcrdbu==5
replace dbeanskgaway=w1_h_agcrdbgv*15 if w1_h_agcrdbu==8
replace dbeanskgaway=w1_h_agcrdbgv*20 if w1_h_agcrdbu==10
replace dbeanskgaway=w1_h_agcrdbgv/2 if w1_h_agcrdbu==13
replace w1_h_agcrdbcon=-9 if w1_h_agcrdbu==99
gen dbeanskgretained=.
replace dbeanskgretained=w1_h_agcrdbcon/2 if w1_h_agcrdbu==1
replace dbeanskgretained=w1_h_agcrdbcon if w1_h_agcrdbu==2
replace dbeanskgretained=w1_h_agcrdbcon*10 if w1_h_agcrdbu==3
replace dbeanskgretained=w1_h_agcrdbcon*25 if w1_h_agcrdbu==4
replace dbeanskgretained=w1_h_agcrdbcon*50 if w1_h_agcrdbu==5
replace dbeanskgretained=w1_h_agcrdbcon*15 if w1_h_agcrdbu==8
replace dbeanskgretained=w1_h_agcrdbcon*20 if w1_h_agcrdbu==10
replace dbeanskgretained=w1_h_agcrdbcon/2 if w1_h_agcrdbu==13

**Lettuce**

gen lettucekg=.
replace lettucekg=w1_h_agcrlethar/2 if w1_h_agcrletu==1
replace lettucekg=w1_h_agcrlethar if w1_h_agcrletu==2
replace lettucekg=w1_h_agcrlethar*5 if w1_h_agcrletu==8
gen lettucekgsold=.
replace lettucekgsold=w1_h_agcrletsll*5 if w1_h_agcrletu==8
gen lettucekgaway=.
replace lettucekg=w1_h_agcrletgv if w1_h_agcrletu==2
replace lettucekg=w1_h_agcrletgv*5 if w1_h_agcrletu==8
gen lettucekgretained=.
replace lettucekgretained=w1_h_agcrletcon/2 if w1_h_agcrletu==1
replace lettucekgretained=w1_h_agcrletcon if w1_h_agcrletu==2
replace lettucekgretained=w1_h_agcrletcon*5 if w1_h_agcrletu==8

**Beetroot**

gen beetrootkg=.
replace beetrootkg=w1_h_agcrbrhar/5 if w1_h_agcrbru==1
replace beetrootkg=w1_h_agcrbrhar if w1_h_agcrbru==2
replace beetrootkg=w1_h_agcrbrhar*10 if w1_h_agcrbru==3
replace beetrootkg=w1_h_agcrbrhar if w1_h_agcrbru==13
replace beetrootkg=-9 if w1_h_agcrbrhar==-9
gen beetrootkgsold=.
replace beetrootkgsold=w1_h_agcrbrsll/5 if w1_h_agcrbru==1
replace beetrootkgsold=w1_h_agcrbrsll if w1_h_agcrbru==2
replace beetrootkgsold=w1_h_agcrbrsll*10 if w1_h_agcrbru==3
replace beetrootkgsold=w1_h_agcrbrsll if w1_h_agcrbru==13
gen beetrootkgaway=.
replace beetrootkgaway=w1_h_agcrbrgv/5 if w1_h_agcrbru==1
replace beetrootkgaway=w1_h_agcrbrgv if w1_h_agcrbru==2
replace beetrootkgaway=w1_h_agcrbrgv*10 if w1_h_agcrbru==3
replace beetrootkgaway=w1_h_agcrbrgv if w1_h_agcrbru==13
replace beetrootkgaway=-3 if w1_h_agcrbrgv==-3
gen beetrootkgretained=.
replace beetrootkgretained=w1_h_agcrbrcon/5 if w1_h_agcrbru==1
replace beetrootkgretained=w1_h_agcrbrcon if w1_h_agcrbru==2
replace beetrootkgretained=w1_h_agcrbrcon*10 if w1_h_agcrbru==3
replace beetrootkgretained=w1_h_agcrbrcon if w1_h_agcrbru==13
replace beetrootkgretained=-9 if w1_h_agcrbrcon==-9
replace beetrootkgretained=-3 if w1_h_agcrbrcon==-3

**Green pepper**

gen gpepperkg=.
replace gpepperkg=w1_h_agcrgphar if w1_h_agcrgpu==1
replace gpepperkg=w1_h_agcrgphar/10 if w1_h_agcrgpu==2
replace gpepperkg=w1_h_agcrgphar*10 if w1_h_agcrgpu==3
gen gpepperkgsold=.
replace gpepperkgsold=w1_h_agcrgpsll/10 if w1_h_agcrgpu==1
replace gpepperkgsold=w1_h_agcrgpsll if w1_h_agcrgpu==2
replace gpepperkgsold=w1_h_agcrgpsll*10 if w1_h_agcrgpu==3
gen gpepperkgaway=.
replace gpepperkgaway=w1_h_agcrgpgv/10 if w1_h_agcrgpu==1
replace gpepperkgaway=w1_h_agcrgpgv if w1_h_agcrgpu==2
replace gpepperkgaway=w1_h_agcrgpgv*10 if w1_h_agcrgpu==3
gen gpepperkgretained=.
replace gpepperkgretained=w1_h_agcrgpcon/10 if w1_h_agcrgpu==1
replace gpepperkgretained=w1_h_agcrgpcon if w1_h_agcrgpu==2
replace gpepperkgretained=w1_h_agcrgpcon*10 if w1_h_agcrgpu==3
replace gpepperkg=-9 if gpepperkg<0

**Other**

gen otherkg=.
replace otherkg=w1_h_agcrveghar/5 if w1_h_agcrvegu==1
replace otherkg=w1_h_agcrveghar if w1_h_agcrvegu==2
replace otherkg=w1_h_agcrveghar*10 if w1_h_agcrvegu==3
replace otherkg=w1_h_agcrveghar*25 if w1_h_agcrvegu==4
replace otherkg=w1_h_agcrveghar*50 if w1_h_agcrvegu==5
replace otherkg=w1_h_agcrveghar*1000 if w1_h_agcrvegu==9
replace otherkg=w1_h_agcrveghar*1000 if w1_h_agcrvegu==7
replace otherkg=w1_h_agcrveghar*10 if w1_h_agcrvegu==8
gen otherkgsold=.
replace otherkgsold=w1_h_agcrvegsll/5 if w1_h_agcrvegu==1
replace otherkgsold=w1_h_agcrvegsll if w1_h_agcrvegu==2
replace otherkgsold=w1_h_agcrvegsll*1000 if w1_h_agcrvegu==7
replace otherkgsold=w1_h_agcrvegsll*10 if w1_h_agcrvegu==8
gen otherkgaway=.
replace otherkgaway=w1_h_agcrveggv/5 if w1_h_agcrvegu==1
replace otherkgaway=w1_h_agcrveggv if w1_h_agcrvegu==2
replace otherkgaway=w1_h_agcrveggv*10 if w1_h_agcrvegu==8
gen otherkgretained=.
replace otherkgretained=w1_h_agcrvegcon/5 if w1_h_agcrvegu==1
replace otherkgretained=w1_h_agcrvegcon if w1_h_agcrvegu==2
replace otherkgretained=w1_h_agcrvegcon*10 if w1_h_agcrvegu==3
replace otherkgretained=w1_h_agcrvegcon*25 if w1_h_agcrvegu==4
replace otherkgretained=w1_h_agcrvegcon*50 if w1_h_agcrvegu==5
replace otherkgretained=w1_h_agcrvegcon*1000 if w1_h_agcrvegu==7
replace otherkgretained=w1_h_agcrvegcon*10 if w1_h_agcrvegu==8

**Correcting for missing codes (some have been modified in previous calculations)**

replace lucernekg=-3 if lucernekg==-30
replace lucernekgretained=-3 if lucernekgretained==-30
replace sugarcanekg=-9 if sugarcanekg==-9000
replace sugarcanekg=-3 if sugarcanekg==-30
replace sugarcanekgsold=-3 if sugarcanekgsold==-1.5
replace sugarcanekgsold=-3 if sugarcanekgsold==-3000
replace sugarcanekgsold=-9 if sugarcanekgsold==-9000
replace sugarcanekgaway=-9 if sugarcanekgaway==-9000
replace sugarcanekgaway=-3 if sugarcanekgaway==-3000
replace sugarcanekgaway=-3 if sugarcanekgaway==-1.5
replace sugarcanekgretained=-9 if sugarcanekgretained==-9000
replace sugarcanekgretained=-3 if sugarcanekgretained==-3000
replace sugarcanekgretained=-3 if sugarcanekgretained==-1.5
replace deciduouskg=-3 if deciduouskg==-30
replace deciduouskg=-3 if deciduouskg>-9 & deciduouskg<0
replace deciduouskgsold=-3 if deciduouskgsold==-30|deciduouskgsold==-45
replace deciduouskgsold=-3 if deciduouskgsold>-30 & deciduouskgsold<0
replace deciduouskgaway=-9 if deciduouskgaway==-90
replace deciduouskgaway=-3 if deciduouskgaway==-30
replace deciduouskgaway=-3 if deciduouskgaway>-9 & deciduouskgaway<0
replace deciduouskgretained=-9 if deciduouskgretained==-90
replace deciduouskgretained=-3 if deciduouskgretained==-30
replace deciduouskgretained=-3 if deciduouskgretained>-9 & deciduouskgretained<0
replace citruskg=-3 if citruskg<0
replace citruskgsold=-3 if citruskgsold<0
replace citruskgaway=-3 if citruskgaway<0
replace citruskgretained=-3 if citruskgretained<0
replace subtropkg=-3 if subtropkg>-9 & subtropkg<0
replace subtropkgsold=-3 if subtropkgsold==-30
replace subtropkgsold=-3 if subtropkgsold>-3 & subtropkgsold<0
replace subtropkgaway=-3 if subtropkgaway==-30
replace subtropkgaway=-3 if subtropkgaway>-3 & subtropkgaway<0
replace subtropkgretained=-3 if subtropkgretained==-30
replace subtropkgretained=-3 if subtropkgretained>-3 & subtropkgretained<0
replace tomatokg=-9 if tomatokg==-90
replace tomatokg=-9 if tomatokg==-45
replace tomatokg=-9 if tomatokg<0
replace tomatokgsold=-5 if tomatokgsold==-50
replace tomatokgsold=-3 if tomatokgsold==-45
replace tomatokgsold=-3 if tomatokgsold==-30
replace tomatokgsold=-3 if tomatokgsold<0
replace tomatokgaway=-5 if tomatokgaway==-50
replace tomatokgaway=-3 if tomatokgaway==-45
replace tomatokgaway=-3 if tomatokgaway==-30
replace tomatokgaway=-3 if tomatokgaway>-3 & tomatokgaway<0
replace tomatokgretained=-5 if tomatokgretained==-50
replace tomatokgretained=-3 if tomatokgretained==-45
replace tomatokgretained=-3 if tomatokgretained==-30
replace tomatokgretained=-3 if tomatokgretained>-3 & tomatokgretained<0
replace spinachkg=-3 if spinachkg>-3 & spinachkg<0
replace spinachkgsold=-3 if spinachkgsold==-30
replace spinachkgsold=-3 if spinachkgsold>-3 & spinachkgsold<0
replace spinachkgaway=-3 if spinachkgaway==-30
replace spinachkgaway=-3 if spinachkgaway>-3 & spinachkgaway<0
replace spinachkgretained=-3 if spinachkgretained==-30
replace spinachkgretained=-3 if spinachkgretained>-3 & spinachkgretained<0
replace marogokg=-9 if marogokg==-9000
replace marogokg=-3 if marogokg>-9 & marogokg<0
replace marogokgsold=-3 if marogokgsold>-3 & marogokgsold<0
replace marogokgaway=-9 if marogokgaway==-9000
replace marogokgaway=-3 if marogokgaway>-3 & marogokgaway<0
replace marogokgretained=-3 if marogokgretained==-30
replace marogokgretained=-3 if marogokgretained>-3 & marogokgretained<0
replace cabbagekg=-3 if cabbagekg==-4.5
replace cabbagekg=-3 if cabbagekg==-1.5
replace cabbagekgsold=-3 if cabbagekgsold<0
replace cabbagekgaway=-3 if cabbagekgaway<0
replace cabbagekgretained=-3 if cabbagekgretained<0
replace potatokg=-9 if potatokg==-135
replace potatokg=-3 if potatokg==-30
replace potatokg=-3 if potatokg>-3 & potatokg<0
replace potatokgsold=-3 if potatokgsold==-30
replace potatokgsold=-3 if potatokgsold>-3 & potatokgsold<0
replace potatokgaway=-3 if potatokgaway==-30
replace potatokgaway=-3 if potatokgaway>-3 & potatokgaway<0
replace potatokgretained=-9 if potatokgretained==-135
replace potatokgretained=-3 if potatokgretained==-30
replace potatokgretained=-3 if potatokgretained>-3 & potatokgretained<0
replace pumpkinkgretained=-3 if pumpkinkgretained==-30
replace pumpkinkg=-3 if pumpkinkg==-30
replace pumpkinkg=-3 if pumpkinkg<-3
replace pumpkinkgsold=-3 if pumpkinkgsold<-3
replace pumpkinkgretained=-3 if pumpkinkgretained<-3
replace carrotkg=-3 if carrotkg==-30
replace carrotkg=-9 if carrotkg>-9 & carrotkg<-.3
replace carrotkg=-3 if carrotkg>-0.4 & carrotkg<0
replace carrotkgsold=-3 if carrotkgsold==-30
replace carrotkgsold=-9 if carrotkgsold>-3 & carrotkgsold<-0.5
replace carrotkgsold=-3 if carrotkgsold>-0.5 & carrotkgsold<0
replace carrotkgaway=-3 if carrotkgaway==-30
replace carrotkgaway=-3 if carrotkgaway>-3 & carrotkgaway<0
replace carrotkgretained=-3 if carrotkgretained==-30
replace carrotkgretained=-9 if carrotkgretained>-3 & carrotkgretained<-0.5
replace carrotkgretained=-3 if carrotkgretained>-0.5 & carrotkgretained<0
replace madumbekg=-9 if madumbekg>-3 & madumbekg<0
replace madumbekgsold=-3 if madumbekgsold==-30
replace madumbekgsold=-3 if madumbekgsold>-3 & madumbekgsold<0
replace madumbekgaway=-3 if madumbekgaway==-45
replace madumbekgaway=-3 if madumbekgaway==-30
replace madumbekgaway=-3 if madumbekgaway>-3 & madumbekgaway<0
replace madumbekgretained=-3 if madumbekgretained<-9
replace madumbekgretained=-3 if madumbekgretained>-3 & madumbekgretained<0
replace gbeanskg=-9 if  gbeanskg==-4.5
replace gbeanskg=-3 if  gbeanskg==-1.5
replace gbeanskgsold=-3 if gbeanskgsold<-3
replace gbeanskgsold=-3 if gbeanskgsold>-3 & gbeanskgsold<0
replace gbeanskgaway=-3 if gbeanskgaway<-3
replace gbeanskgaway=-3 if gbeanskgaway>-3 & gbeanskgaway<0
replace gbeanskgretained=-3 if gbeanskgretained<-9
replace gbeanskgretained=-3 if gbeanskgretained==-4.5
replace gbeanskgretained=-3 if gbeanskgretained>-3 & gbeanskgretained<0
replace dbeanskgaway=-9 if dbeanskgaway==-135
replace dbeanskgaway=-3 if dbeanskgaway==-75
replace dbeanskgaway=-3 if dbeanskgaway==-45
replace dbeanskgaway=-3 if dbeanskgaway==-30
replace dbeanskgretained=-9 if dbeanskgretained==-135
replace dbeanskgretained=-3 if dbeanskgretained==-75
replace dbeanskgretained=-3 if dbeanskgretained==-45
replace dbeanskgretained=-3 if dbeanskgretained==-30
replace dbeanskgretained=-3 if dbeanskgretained==-1.5
replace lettucekg=-3 if lettucekg==-15
replace lettucekgsold=-3 if lettucekgsold==-15
replace lettucekgretained=-3 if lettucekgretained<0
replace otherkg=-3 if otherkg==-30
replace otherkg=-3 if otherkg>-9 & otherkg<0
replace otherkgsold=-3 if otherkgsold<0
replace otherkgaway=-3 if otherkgaway<0
replace otherkgretained=-3 if otherkgretained==-30
replace otherkgretained=-3 if otherkgretained>-9 & otherkgretained<0
replace onionkg=-9 if onionkg>-9 & onionkg<-.5
replace onionkg=-3 if onionkg>-0.5 &  onionkg<0
replace onionkgsold=-3 if onionkgsold<-9
replace onionkgsold=-3 if onionkgsold>-3 & onionkgsold<0
replace onionkgaway=-3 if onionkgaway<-3
replace onionkgaway=-3 if onionkgaway>-3 & onionkgaway<0
replace onionkgretained=-3 if onionkgretained<-9
replace onionkgretained=-9 if onionkgretained>-3 & onionkgretained<-0.5
replace onionkgretained=-3 if onionkgretained>-0.5 & onionkgretained<0
replace mieliekg=-3 if mieliekg<0
replace mieliekgsold=-3 if mieliekgsold<0
replace mieliekgaway=-3 if mieliekgaway<0
replace mieliekgretained=-3 if mieliekgretained<0
replace subtropkgsold=-3 if subtropkgsold==-15
replace subtropkgaway=-3 if subtropkgaway==-15
replace subtropkgretained=-3 if  subtropkgretained==-15
replace  dbeanskg=-3 if dbeanskg==-1.5
replace dbeanskgaway=-3 if dbeanskgaway==-1.5
replace  pumpkinkgaway=-3 if pumpkinkgaway<-3

**Drop all variables for which there are no observations**

/*drop wheatkg
drop wheatkgsold
drop cottonkg
drop cottonkgretained
drop cottonkgsold
drop lucernekgsold*/


*================================================================================================================================================
**Creating a per kg value for mielies**

gen piglet=mieliekgsold
replace piglet=0 if piglet<0
gen mieliekgprice2=2 if  w1_h_agcrml==1 & mieliekg>0 & mieliekg!=.
replace mieliekgprice2=w1_h_agcrmlval/piglet if w1_h_agcrmlval>0 & w1_h_agcrmlval!=. & piglet>0 & piglet!=.
drop piglet

**No positive reports of harvest for wheat. (Is it worth dropping wheat?)**

**Cannot compute a kilo value for millet/sorghum/lucerne from the data so use R2 per kilo** 

**No cotton harvested. (Drop all cotton variables?)**

**Creating a per kg value for sugarcane**

gen piglet=sugarcanekgsold
replace piglet=0 if piglet<0
gen sugarcanekgprice2=1.666 if w1_h_agcrsug==1 & sugarcanekg>0 & sugarcanekg!=.
replace sugarcanekgprice2= w1_h_agcrsugval/piglet if w1_h_agcrsugval>0 & w1_h_agcrsugval!=. & piglet>0 & piglet!=.
drop piglet

**Cannot compute a kilo value for tea from the data so use R4 per kilo**

**No timber harvested. (Drop all timber variables?)**

**Cannot compute a kilo value for other grains from the data so use R2 per kilo**

**Creating a per kg value for deciduous fruit**

gen piglet=deciduouskgsold
replace piglet=0 if piglet<0
gen deciduouskgprice2=1.5 if w1_h_agcrdec==1 & deciduouskg>0 & deciduouskg!=.
replace deciduouskgprice2= w1_h_agcrdecval/piglet if  w1_h_agcrdecval>0 &  w1_h_agcrdecval!=. & piglet>0 & piglet!=.
drop piglet

**Creating a per kg value for citrus fruit**

gen piglet=citruskgsold
replace piglet=0 if piglet<0
gen citruskgprice2=3.5 if  w1_h_agcrcit==1 & citruskg>0 & citruskg!=.
replace citruskgprice2= w1_h_agcrcitval/piglet if  w1_h_agcrcitval>0 &  w1_h_agcrcitval!=. & piglet>0 & piglet!=.
drop piglet

**Creating a per kg value for subtropical fruit**

gen piglet=subtropkgsold
replace piglet=0 if piglet<0
gen subtropkgprice2=2.667 if w1_h_agcrsub==1 & subtropkg>0 & subtropkg!=.
replace subtropkgprice= w1_h_agcrsubval/piglet if w1_h_agcrsubval>0 & w1_h_agcrsubval!=. & piglet>0 & piglet!=.
drop piglet

**Creating a per kg value for other fruit**
**There is an outlier that reports selling other fruit at R5000 per kilo. Rather change this to the market price of R2 per kilo**

**Creating a per kg value for tomatos**

gen piglet=tomatokgsold
replace piglet=0 if piglet<0
gen tomatokgprice2=3.388 if w1_h_agcrtom==1 & tomatokg>0 & tomatokg!=.
replace tomatokgprice2= w1_h_agcrtomval/piglet if w1_h_agcrtomval>0 & w1_h_agcrtomval!=. & piglet>0 & piglet!=.
drop piglet

**Creating a per kg value for spinach**

gen piglet=spinachkgsold
replace piglet=0 if piglet<0
gen spinachkgprice2=4.5 if  w1_h_agcrspi==1 & spinachkg>0 & spinachkg!=.
replace spinachkgprice2= w1_h_agcrspival/piglet if w1_h_agcrspival>0 & w1_h_agcrspival!=. & piglet>0 & piglet!=.
drop piglet

**Creating a per kg value for morogo (wild spinach)**

gen piglet=marogokgsold
replace piglet=0 if piglet<0
gen marogokgprice2=4 if  w1_h_agcrws==1 & marogokg>0 & marogokg!=.
replace marogokgprice2= w1_h_agcrwsval/piglet if w1_h_agcrwsval>0 & w1_h_agcrwsval!=. & piglet>0 & piglet!=.
drop piglet

**Creating a per kg value for cabbage**

gen piglet=cabbagekgsold
replace piglet=0 if piglet<0
gen cabbagekgprice2=3 if  w1_h_agcrcab==1 & cabbagekg>0 & cabbagekg!=.
replace cabbagekgprice2= w1_h_agcrcabval/piglet if w1_h_agcrcabval>0 & w1_h_agcrcabval!=. & piglet>0 & piglet!=.
drop piglet

**Creating a per kg value for potatos**

gen piglet=potatokgsold
replace piglet=0 if piglet<0
gen potatokgprice2=3 if  w1_h_agcrpot==1 & potatokg>0 & potatokg!=.
replace potatokgprice2= w1_h_agcrpotval/piglet if w1_h_agcrpotval>0 & w1_h_agcrpotval!=. & piglet>0 & piglet!=.
drop piglet

**Creating a per kg value for pumpkins**

gen piglet=pumpkinkgsold
replace piglet=0 if piglet<0
gen pumpkinkgprice2=4 if w1_h_agcrpmp==1 & pumpkinkg>0 & pumpkinkg!=.
replace pumpkinkgprice2= w1_h_agcrpmpval/piglet if w1_h_agcrpmpval>0 & w1_h_agcrpmpval!=. & piglet>0 & piglet!=.
drop piglet

**Creating a per kg value for carrots**

gen piglet=carrotkgsold
replace piglet=0 if piglet<0
gen carrotkgprice2=3 if w1_h_agcrcar==1 & carrotkg>0 & carrotkg!=.
replace carrotkgprice2= w1_h_agcrcarval/piglet if w1_h_agcrcarval>0 & w1_h_agcrcarval!=. & piglet>0 & piglet!=.
drop piglet

**Creating a per kg value for madumbe**

gen piglet=madumbekgsold
replace piglet=0 if piglet<0
gen madumbekgprice2=3 if w1_h_agcrmad==1 & madumbekg>0 & madumbekg!=.
replace madumbekgprice2= w1_h_agcrmadval/piglet if w1_h_agcrmadval>0 & w1_h_agcrmadval!=. & piglet>0 & piglet!=.
drop piglet

**Creating a per kg value for onions**

gen piglet=onionkgsold
replace piglet=0 if piglet<0
gen onionkgprice2=4 if w1_h_agcroni==1 & onionkg>0 & onionkg!=.
replace onionkgprice2= w1_h_agcronival/piglet if w1_h_agcronival>0 & w1_h_agcronival!=. & piglet>0 & piglet!=.
drop piglet


**Creating a per kg value for green beans**

gen piglet=gbeanskgsold
replace piglet=0 if piglet<0
gen gbeanskgprice2=2 if  w1_h_agcrgb==1 & gbeanskg>0 & gbeanskg!=.
replace gbeanskgprice2= w1_h_agcrgbval/piglet if  w1_h_agcrgbval>0 & w1_h_agcrgbval!=. & piglet>0 & piglet!=.
drop piglet

**Cannot compute a per kilo value for legumes/dry beans from the data. 2 HHs reported selling legumes but their unit of measurement is missing. Use R2 per kilo**

**Creating a per kg value for lettuce**

gen piglet=lettucekgsold
replace piglet=0 if piglet<0
gen lettucekgprice2=2 if w1_h_agcrlet==1 & lettucekg>0 & lettucekg!=.
replace lettucekgprice2= w1_h_agcrletval/piglet if w1_h_agcrletval>0 & w1_h_agcrletval!=. & piglet>0 & piglet!=.
drop piglet

**Creating a per kg value for other vegetables*

gen piglet=otherkgsold
replace piglet=0 if piglet<0
gen otherkgprice2=2 if  w1_h_agcrveg==1 & otherkg>0 & otherkg<=.
replace otherkgprice2= w1_h_agcrvegval/piglet if w1_h_agcrvegval>0 & w1_h_agcrvegval!=. & piglet>0 & piglet!=.
drop piglet

**Cannot compute a per kilo value for beetroot from the data so use R5**

**Cannot compute a per kilo value for green peppers from the data so use R5**

*================================================================================================================================================

**Now to create the agriculture income variable, using price as the median from the survey where appropriate and as the farm gate price elsewhere**

gen mielieinc=.
replace mielieinc=mieliekg*mieliekgprice2
gen beetrootinc=.
replace beetrootinc=beetrootkg*5
gen milletinc=.
replace milletinc=milletkg*2
gen teainc=.
replace teainc=teakg*4
gen gpepperinc=.
replace gpepperinc=gpepperkg*5
gen sorghuminc=.
replace sorghuminc=sorghumkg*2
gen onioninc=.
replace onioninc=onionkg*onionkgprice2
gen lucerneinc=.
replace lucerneinc=lucernekg*2
gen othergraininc=.
replace othergraininc=othergrainkg*2
gen sugarcaneinc=.
replace sugarcaneinc=sugarcanekg*sugarcanekgprice2
gen deciduousinc=.
replace deciduousinc=deciduouskg*deciduouskgprice2
gen citrusinc=.
replace citrusinc=citruskg*citruskgprice2
gen subtropinc=.
replace subtropinc=subtropkg*subtropkgprice2
gen otherfrinc=.
replace otherfrinc=otherfrkg*2
gen otherinc=.
replace otherinc=otherkg*otherkgprice2
gen tomatoinc=.
replace tomatoinc=tomatokg*tomatokgprice2
gen spinachinc=.
replace spinachinc=spinachkg*spinachkgprice2
gen marogoinc=.
replace marogoinc=marogokg*marogokgprice2
gen cabbageinc=.
replace cabbageinc=cabbagekg*cabbagekgprice2
gen potatoinc=.
replace potatoinc=potatokg*potatokgprice2
gen pumpkininc=.
replace pumpkininc=pumpkinkg*pumpkinkgprice2
gen carrotinc=.
replace carrotinc=carrotkg*carrotkgprice2
gen madumbeinc=.
replace madumbeinc=madumbekg*madumbekgprice2
gen gbeansinc=.
replace gbeansinc=gbeanskg*gbeanskgprice2
gen dbeansinc=.
replace dbeansinc=dbeanskg*2
gen lettuceinc=.
replace lettuceinc=lettucekg*lettucekgprice2

drop mieliekgprice2 sugarcanekgprice2 deciduouskgprice2 citruskgprice2 subtropkgprice2 tomatokgprice2 spinachkgprice2 marogokgprice2 cabbagekgprice2 potatokgprice2 pumpkinkgprice2 carrotkgprice2 madumbekgprice2 onionkgprice2 gbeanskgprice2 lettucekgprice2 otherkgprice2

**Sum across to get total income from crop production**

gen mielieinc2=.
replace mielieinc2=mielieinc
replace mielieinc2=0 if mielieinc<=0
replace mielieinc2=0 if mielieinc==.
gen beetrootinc2=.
replace beetrootinc2=beetrootinc
replace beetrootinc2=0 if beetrootinc<0
replace beetrootinc2=0 if beetrootinc==.
gen milletinc2=.
replace milletinc2=milletinc
replace milletinc2=0 if milletinc<=0
replace milletinc2=0 if milletinc==.
gen teainc2=.
replace teainc2=teainc
replace teainc2=0 if teainc<=0
replace teainc2=0 if teainc==.
gen gpepperinc2=.
replace gpepperinc2=gpepperinc
replace gpepperinc2=0 if gpepperinc<=0
replace gpepperinc2=0 if gpepperinc==.
gen othergraininc2=.
replace othergraininc2=othergraininc
replace othergraininc2=0 if othergraininc<=0
replace othergraininc2=0 if othergraininc==.
gen sorghuminc2=.
replace sorghuminc2=sorghuminc
replace sorghuminc2=0 if sorghuminc<=0
replace sorghuminc2=0 if sorghuminc==.
gen onioninc2=.
replace onioninc2=onioninc
replace onioninc2=0 if onioninc<=0
replace onioninc2=0 if onioninc==.
gen otherinc2=.
replace otherinc2=otherinc
replace otherinc2=0 if otherinc<=0
replace otherinc2=0 if otherinc==.
gen lucerneinc2=.
replace lucerneinc2=lucerneinc
replace lucerneinc2=0 if lucerneinc<=0
replace lucerneinc2=0 if lucerneinc==.
gen sugarcaneinc2=.
replace sugarcaneinc2=sugarcaneinc
replace sugarcaneinc2=0 if sugarcaneinc<=0
replace sugarcaneinc2=0 if sugarcaneinc==.
gen deciduousinc2=.
replace deciduousinc2=deciduousinc
replace deciduousinc2=0 if deciduousinc<=0
replace deciduousinc2=0 if deciduousinc==.
gen citrusinc2=.
replace citrusinc2=citrusinc
replace citrusinc2=0 if citrusinc<=0
replace citrusinc2=0 if citrusinc==.
gen subtropinc2=.
replace subtropinc2=subtropinc
replace subtropinc2=0 if subtropinc<=0
replace subtropinc2=0 if subtropinc==.
gen otherfrinc2=.
replace otherfrinc2=otherfrinc
replace otherfrinc2=0 if otherfrinc<=0
replace otherfrinc2=0 if otherfrinc==.
gen tomatoinc2=.
replace tomatoinc2=tomatoinc
replace tomatoinc2=0 if tomatoinc<=0
replace tomatoinc2=0 if tomatoinc==.
gen spinachinc2=.
replace spinachinc2=spinachinc
replace spinachinc2=0 if spinachinc<=0
replace spinachinc2=0 if spinachinc==.
gen marogoinc2=.
replace marogoinc2=marogoinc
replace marogoinc2=0 if marogoinc<=0
replace marogoinc2=0 if marogoinc==.
gen cabbageinc2=.
replace cabbageinc2=cabbageinc
replace cabbageinc2=0 if cabbageinc<=0
replace cabbageinc2=0 if cabbageinc==.
gen potatoinc2=.
replace potatoinc2=potatoinc
replace potatoinc2=0 if potatoinc<=0
replace potatoinc2=0 if potatoinc==.
gen pumpkininc2=.
replace pumpkininc2=pumpkininc
replace pumpkininc2=0 if pumpkininc<=0
replace pumpkininc2=0 if pumpkininc==.
gen carrotinc2=.
replace carrotinc2=carrotinc
replace carrotinc2=0 if carrotinc<=0
replace carrotinc2=0 if carrotinc==.
gen madumbeinc2=.
replace madumbeinc2=madumbeinc
replace madumbeinc2=0 if madumbeinc<=0
replace madumbeinc2=0 if madumbeinc==.
gen gbeansinc2=.
replace gbeansinc2=gbeansinc
replace gbeansinc2=0 if gbeansinc<=0
replace gbeansinc2=0 if gbeansinc==.
gen dbeansinc2=.
replace dbeansinc2=dbeansinc
replace dbeansinc2=0 if dbeansinc<=0
replace dbeansinc2=0 if dbeansinc==.
gen lettuceinc2=.
replace lettuceinc2=lettuceinc
replace lettuceinc2=0 if lettuceinc<=0
replace lettuceinc2=0 if lettuceinc==.

gen produceinc= mielieinc2+ beetrootinc2+ milletinc2+ teainc2+ gpepperinc2+ sorghuminc2+ onioninc2+ lucerneinc2+ sugarcaneinc2+ deciduousinc2+ citrusinc2+ subtropinc2+ otherfrinc2+ tomatoinc2+ spinachinc2+ marogoinc2+ cabbageinc2+ potatoinc2+ pumpkininc2+ carrotinc2+ madumbeinc2+ gbeansinc2+ dbeansinc2+ lettuceinc2

drop mielieinc2 beetrootinc2 milletinc2 teainc2 gpepperinc2 sorghuminc2 onioninc2 lucerneinc2 sugarcaneinc2 deciduousinc2 citrusinc2 subtropinc2 otherfrinc2 tomatoinc2 spinachinc2 marogoinc2 othergraininc2 otherinc2 cabbageinc2 potatoinc2 pumpkininc2 carrotinc2 madumbeinc2 gbeansinc2 dbeansinc2 lettuceinc2
drop wheatkg wheatkgsold milletkg lucernekgsold cottonkg cottonkgsold cottonkgretained teakg teakgaway teakgretained othergrainkg othergrainkgsold otherkg otherkgsold otherkgaway otherkgretained milletinc teainc othergraininc otherinc


*================================================================================================================================================

**Moving across to livestock and livestock-related produce**


**Estimating the value of a single unit of livestock**

gen cowprice=.
replace cowprice=w1_h_aglscatval/w1_h_aglscatsll
replace cowprice=0 if cowprice<0
replace cowprice=0 if cowprice==.
replace cowprice=2800 if cowprice==0 & w1_h_aglscatsll>0 & w1_h_aglscatsll!=.
gen sheepprice=.
replace sheepprice=w1_h_aglsshpval/w1_h_aglsshpsll
replace sheepprice=0 if sheepprice<0
replace sheepprice=0 if sheepprice==.
replace sheepprice=600 if sheepprice==0 & w1_h_aglsshpsll>0 & w1_h_aglsshpsll!=.
gen goatprice=.
replace goatprice=w1_h_aglsgtval/w1_h_aglsgtsll
**For the following 4 HHs it was not possible to attain a value per goat from the questionaire. Because of this, the median value of a goat (R500) was assigned**
replace goatprice=500 if w1_hhid==108912
replace goatprice=500 if w1_hhid==103743
replace goatprice=500 if w1_hhid==104117
replace goatprice=500 if w1_hhid==102264
replace goatprice=0 if goatprice<0
replace goatprice=0 if goatprice==.
replace goatprice=500 if goatprice==0 & w1_h_aglsgtsll>0 & w1_h_aglsgtsll!=.
gen pigprice=.
replace pigprice=w1_h_aglspigval/w1_h_aglspigsll
replace pigprice=0 if pigprice<0
replace pigprice=0 if pigprice==.
**no HHs reported selling any horses, so price of a horse is set to 1000**
gen donkeyprice=.
replace donkeyprice=w1_h_aglsdnkval/w1_h_aglsdnksll
replace donkeyprice=0 if donkeyprice==.
gen chickenprice=.
replace chickenprice=w1_h_aglschcval/w1_h_aglschcsll
replace chickenprice=30 if chickenprice==0 & w1_h_aglschcsll>0 & w1_h_aglschcsll!=.
replace chickenprice=0 if chickenprice<0
gen duckprice=.
replace duckprice=w1_h_aglsdckval/w1_h_aglsdcksll
**no HHs with income from ostriches**

**Livestock income**

gen cattleinc=.
replace cattleinc = (w1_h_aglscatsll + w1_h_aglscatgv + w1_h_aglscatcon - w1_h_aglscatlss)*cowprice
gen sheepinc=.
replace sheepinc = (w1_h_aglsshpsll + w1_h_aglsshpgv + w1_h_aglsshpcon - w1_h_aglsshplss)*sheepprice
gen goatinc=.
replace goatinc = (w1_h_aglsgtsll + w1_h_aglsgtgv + w1_h_aglsgtcon - w1_h_aglsgtlss)*goatprice
gen piginc=.
replace piginc= (w1_h_aglspigsll + w1_h_aglspiggv + w1_h_aglspigcon - w1_h_aglspiglss)*pigprice
gen horseinc=.
replace horseinc = (w1_h_aglshrssll + w1_h_aglshrsgv + w1_h_aglshrscon - w1_h_aglshrslss)*1000
gen donkeyinc=.
replace donkeyinc = (w1_h_aglsdnksll + w1_h_aglsdnkgv + w1_h_aglsdnkcon - w1_h_aglsdnklss)*donkeyprice
gen chickeninc=.
replace chickeninc= (w1_h_aglschcsll + w1_h_aglschcgv + w1_h_aglschccon - w1_h_aglschclss)*chickenprice
gen duckinc=.
replace duckinc = (w1_h_aglsdcksll + w1_h_aglsdckgv + w1_h_aglsdckcon - w1_h_aglsdcklss)*duckprice
gen rabbitinc=.
replace rabbitinc= (w1_h_aglsrabsll + w1_h_aglsrabgv + w1_h_aglsrabcon - w1_h_aglsrablss)*10
gen turkeyinc=.
replace turkeyinc = (w1_h_aglstursll + w1_h_aglsturgv + w1_h_aglsturcon - w1_h_aglsturlss)*100

gen cattleinc2=.
replace cattleinc2=cattleinc if cattleinc!=.
replace cattleinc2=0 if cattleinc==.
gen goatinc2=.
replace goatinc2=goatinc if goatinc!=.
replace goatinc2=0 if goatinc==.
gen sheepinc2=.
replace sheepinc2=sheepinc if sheepinc!=.
replace sheepinc2=0 if sheepinc==.
gen piginc2=.
replace piginc2=piginc if piginc!=.
replace piginc2=0 if piginc==.
gen horseinc2=.
replace horseinc2=horseinc if horseinc!=.
replace horseinc2=0 if horseinc==.
gen donkeyinc2=.
replace donkeyinc2=donkeyinc if donkeyinc!=.
replace donkeyinc2=0 if donkeyinc==.
gen chickeninc2=.
replace chickeninc2=chickeninc if chickeninc!=.
replace chickeninc2=0 if chickeninc==.
gen duckinc2=.
replace duckinc2=duckinc if duckinc!=.
replace duckinc2=0 if duckinc==.
gen ostrichinc2=.
replace ostrichinc2=ostrichinc if ostrichinc!=.
replace ostrichinc2=0 if ostrichinc==.
gen rabbitinc2=.
replace rabbitinc2=rabbitinc if rabbitinc!=.
replace rabbitinc2=0 if rabbitinc==.
gen turkeyinc2=.
replace turkeyinc2=turkeyinc if turkeyinc!=.
replace turkeyinc2=0 if turkeyinc==.

gen animalinc=.
replace animalinc =  cattleinc2+ goatinc2+ sheepinc2+ piginc2+ horseinc2+ donkeyinc2+ chickeninc2+ duckinc2+ ostrichinc2+ rabbitinc2+ turkeyinc2

drop cattleinc sheepinc goatinc piginc horseinc donkeyinc chickeninc duckinc ostrichinc rabbitinc turkeyinc cattleinc2 goatinc2 sheepinc2 piginc2 horseinc2 donkeyinc2 chickeninc2 duckinc2 ostrichinc2 rabbitinc2 turkeyinc2

*================================================================================================================================================

**Getting income from eggs**

gen eggunits=.
replace eggunits=w1_h_ageggnum*12 if w1_h_ageggu==1
replace eggunits=w1_h_ageggnum if w1_h_ageggu==2
replace eggunits=-3 if eggunits==-108
replace eggunits=-3 if eggunits==-36
gen eggunitannual=.
replace eggunitannual=eggunits*12
replace eggunits=-3 if eggunits==-36
replace eggunitannual=-3 if eggunitannual==-108
gen egginc=.
replace egginc=eggunitannual/2
replace egginc=0 if eggunitannual==.
replace egginc=-3 if egginc==-1.5
replace egginc=0 if egginc==-3

**Milk**

gen milklitre=.
replace milklitre=-9 if w1_h_agdrmlkm==-9
replace milklitre=-3 if w1_h_agdrmlkm==-3
replace milklitre=w1_h_agdrmlkprd if w1_h_agdrmlkm==1
replace milklitre=w1_h_agdrmlkprd if w1_h_agdrmlkm==2
replace milklitre=w1_h_agdrmlkprd*10 if w1_h_agdrmlkm==3
replace milklitre=w1_h_agdrmlkprd*50 if w1_h_agdrmlkm==5
replace milklitre=w1_h_agdrmlkprd*80 if w1_h_agdrmlkm==6
replace milklitre=w1_h_agdrmlkprd*25 if w1_h_agdrmlkm==10
replace milklitre=w1_h_agdrmlkprd if w1_h_agdrmlkm==12
gen milkincome=.
replace milkincome=milklitre*1.5
replace milkinc=0 if milkinc<0
replace milkinc=0 if milkinc==.

**Butter**

gen butterkg=.
replace butterkg=w1_h_agdrbutprd*10 if w1_h_agdrbutu==3
**only one hh reported a positive figure for butter production**
gen butterinc=.
replace butterinc=butterkg*2

**Wool**

gen woolkg=.
replace woolkg=w1_h_agwlnum*w1_h_agwlm if w1_h_agwlu==1 & w1_h_agwlm>0 & w1_h_agwlm!=.
replace woolkg=w1_h_agwlnum*w1_h_agwlm if w1_h_agwlu==2 & w1_h_agwlm>0 & w1_h_agwlm!=.
replace woolkg=w1_h_agwlnum*10*w1_h_agwlm if w1_h_agwlu==3 & w1_h_agwlm>0 & w1_h_agwlm!=.
replace woolkg=w1_h_agwlnum*25*w1_h_agwlm if w1_h_agwlu==4 & w1_h_agwlm>0 & w1_h_agwlm!=.
replace woolkg=w1_h_agwlnum*50*w1_h_agwlm if w1_h_agwlu==5 & w1_h_agwlm>0 & w1_h_agwlm!=.
replace woolkg=w1_h_agwlnum*25*w1_h_agwlm if w1_h_agwlu==10 & w1_h_agwlm>0 & w1_h_agwlm!=.
gen woolinc=.
replace woolinc=woolkg*1.5
replace woolinc=0 if woolinc==.

**Mohair**

gen mohairinc=.
replace mohairinc=w1_h_agmhnum*w1_h_agmhm if w1_h_agmhu==2 & w1_h_agmhnum>0 & w1_h_agmhnum!=.
replace mohairinc=0 if mohairinc==.

gen agricinc=.
replace agricinc = produceinc + animalinc + egginc + milkinc + woolinc + mohairinc

*================================================================================================================================================

gen buylabour=.
replace buylabour=w1_h_agilabspn
replace buylabour=0 if buylabour==.
replace buylabour=0 if buylabour<0
gen buyfertil=.
replace buyfertil=w1_h_agifrtspn
replace buyfertil=0 if buyfertil==.
replace buyfertil=0 if buyfertil<0
gen buymanure=.
replace buymanure=w1_h_agimanspn
replace buymanure=0 if buymanure==.
replace buymanure=0 if buymanure<0
gen buychem=.
replace buychem=w1_h_agichmspn
replace buychem=0 if buychem==.
replace buychem=0 if buychem<0
gen buyplough=.
replace buyplough=w1_h_agiplghspn
replace buyplough=0 if buyplough==.
replace buyplough=0 if buyplough<0
gen buyseeds=.
replace buyseeds=w1_h_agiseedspn
replace buyseeds=0 if buyseeds==.
replace buyseeds=0 if buyseeds<0
gen buydip=.
replace buydip=w1_h_agidipspn
replace buydip=0 if buydip==.
replace buydip=0 if buydip<0
gen buyvet=.
replace buyvet=w1_h_agivetspn
replace buyvet=0 if buyvet==.
replace buyvet=0 if buyvet<0
gen buyfeed=.
replace buyfeed=w1_h_agifeedspn
replace buyfeed=0 if buyfeed==.
replace buyfeed=0 if buyfeed<0
gen buyinvest=.
replace buyinvest=w1_h_agiinvspn
replace buyinvest=0 if buyinvest==.
replace buyinvest=0 if buyinvest<0
gen buyrepair=.
replace buyrepair=w1_h_agirepspn
replace buyrepair=0 if buyrepair==.
replace buyrepair=0 if buyrepair<0

gen inputcosts=.
replace inputcosts= buylabour+ buyfertil+ buymanure+ buychem+ buyplough+ buyseeds+ buydip+ buyvet+ buyfeed+ buyinvest+ buyrepair

*================================================================================================================================================
**Final step of calculating**
gen netagriincome=.
replace netagriincome= agricinc - inputcosts
replace netagriincome=. if w1_h_ag==2

keep w1_hhid netagriincome 
rename netagriincome hhagric
replace hhagric=0 if hhagric<0
replace hhagric=hhagric/12
label variable hhagric "Household average monthly income from subsistence agriculture"

sort w1_hhid

save "$DataOUT\hhagric.dta", replace

*-------------------------------------------------------------------------------------------------------------------------------------
*=====================================================================================================================================
